/****** Object:  StoredProcedure [dbo].[P_RC_CLI_ANALISE_PONTUACAO_FIDELIDADE]    Script Date: 04/30/2013 17:54:03 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CLI_ANALISE_PONTUACAO_FIDELIDADE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_CLI_ANALISE_PONTUACAO_FIDELIDADE]
GO
--EXEC P_RC_CLI_ANALISE_PONTUACAO_FIDELIDADE 0,'2018-08-10','2018-08-10',1,542
CREATE PROCEDURE [dbo].[P_RC_CLI_ANALISE_PONTUACAO_FIDELIDADE] @QTDE_DIAS_PROC INT=30, 
															   @DT_PROC_INI DATETIME=NULL,
															   @DT_PROC_FIM DATETIME=NULL,
															   @CD_EMP_PAR INT =1,
															   @CD_FILIAL_PAR INT =0 AS 
 

set CONTEXT_INFO  0x77777

SET NOCOUNT on;
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_VD INT
DECLARE @CD_IT INT
DECLARE @CD_CLI INT
DECLARE @QTDE_PONTOS MONEY
DECLARE @DT_CAD DATETIME
DECLARE @CD_USU INT
DECLARE @CD_MOTIVO INT

IF @DT_PROC_INI IS NULL
BEGIN
	SET @DT_PROC_INI=convert(varchar(10),getdate()-@QTDE_DIAS_PROC,112)
	SET @DT_PROC_FIM=convert(varchar(10),getdate(),112)
END 

UPDATE
     RC_CLI_FIDELI_PONTOS_CREDITO
SET
	 RC_CLI_FIDELI_PONTOS_CREDITO.QTDE_PONTOS = CASE WHEN EST_PROD_CPL.QTDE_PONTO_FIDEL > 0 THEN
													(PDV_VD_IT.TOT_IT / EST_PROD_CPL.QTDE_PONTO_FIDEL)
												ELSE
													RC_CLI_FIDELI_PONTOS_CREDITO.QTDE_PONTOS
												END,
	RC_CLI_FIDELI_PONTOS_CREDITO.FLAG_REPROCESSADO=1
FROM
     RC_CLI_FIDELI_PONTOS_CREDITO INNER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO ON 
     RC_CLI_FIDELI_PONTOS_CREDITO.CD_CTR_PONTOS = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_CTR_PONTOS 
     INNER JOIN PDV_VD_IT ON 
     RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_EMP = PDV_VD_IT.CD_EMP AND 
     RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND 
     RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_VD = PDV_VD_IT.CD_VD AND 
     RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_IT = PDV_VD_IT.CD_IT 
     INNER JOIN EST_PROD_CPL ON 
     PDV_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP AND 
     PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND 
    PDV_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD
	INNER JOIN PDV_VD ON
	PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
	PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
	PDV_VD_IT.CD_VD = PDV_VD.CD_VD 
WHERE     
     PDV_VD_IT.DT_VD BETWEEN @DT_PROC_INI AND @DT_PROC_FIM
     AND RC_CLI_FIDELI_PONTOS_CREDITO.QTDE_PONTOS>0
	 AND EST_PROD_CPL.QTDE_PONTO_FIDEL >0
	 AND PDV_VD.ST_VD=0
	 AND PDV_VD_IT.ST_IT=1
	 AND PDV_VD_IT.cd_emp=@CD_EMP_PAR
	 AND PDV_VD_IT.CD_FILIAL= CASE WHEN @CD_FILIAL_PAR=0 THEN PDV_VD_IT.CD_FILIAL ELSE @CD_FILIAL_PAR END 
	AND (RC_CLI_FIDELI_PONTOS_CREDITO.FLAG_REPROCESSADO = 0
		OR RC_CLI_FIDELI_PONTOS_CREDITO.FLAG_REPROCESSADO IS NULL);
	 
UPDATE
	PDV_VD_IT_FIDELI_CARTAO
SET  
	VLR_PONTO_IT = (PDV_VD_IT.TOT_IT / EST_PROD_CPL.QTDE_PONTO_FIDEL),
	QTDE_PONTO_FIDEL=EST_PROD_CPL.QTDE_PONTO_FIDEL,
	FLAG_REPROCESSADO=1
FROM 
	PDV_VD_IT_FIDELI_CARTAO INNER JOIN PDV_VD_IT ON 
    PDV_VD_IT_FIDELI_CARTAO.CD_EMP = PDV_VD_IT.CD_EMP AND 
    PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND 
    PDV_VD_IT_FIDELI_CARTAO.CD_VD = PDV_VD_IT.CD_VD AND 
    PDV_VD_IT_FIDELI_CARTAO.CD_IT = PDV_VD_IT.CD_IT 
    INNER JOIN EST_PROD_CPL ON 
    PDV_VD_IT.CD_EMP = EST_PROD_CPL.CD_EMP AND 
    PDV_VD_IT.CD_FILIAL = EST_PROD_CPL.CD_FILIAL AND 
    PDV_VD_IT.CD_PROD = EST_PROD_CPL.CD_PROD
WHERE  
	EST_PROD_CPL.QTDE_PONTO_FIDEL <> PDV_VD_IT_FIDELI_CARTAO.QTDE_PONTO_FIDEL 
    AND PDV_VD_IT.DT_VD BETWEEN @DT_PROC_INI AND @DT_PROC_FIM
	AND EST_PROD_CPL.QTDE_PONTO_FIDEL > 0
	AND PDV_VD_IT_FIDELI_CARTAO.VLR_PONTO_IT >0
	AND PDV_VD_IT.cd_emp=@CD_EMP_PAR
	AND PDV_VD_IT.CD_FILIAL= CASE WHEN @CD_FILIAL_PAR=0 THEN PDV_VD_IT.CD_FILIAL ELSE @CD_FILIAL_PAR END 
	AND (PDV_VD_IT_FIDELI_CARTAO.FLAG_REPROCESSADO = 0
		OR PDV_VD_IT_FIDELI_CARTAO.FLAG_REPROCESSADO IS NULL);

PRINT 'Inicio da rotina - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
PRINT 'Analisando vendas canceladas de fidelidade - Hora : '+ CONVERT(VARCHAR, GETDATE(),108);
set @CD_MOTIVO=ISNULL((SELECT 
						TOP 1 CD_MT_PONTO
					   FROM
						RC_MOTIVO_PONTO
					   WHERE
						CD_ACAO_MT_PONTO=18),0)
						
IF @CD_MOTIVO>0
BEGIN
DECLARE CCancelVendasFidel CURSOR FAST_FORWARD
FOR SELECT
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_EMP,
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL,
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_VD,
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_IT,
	RC_CLI_FIDELI_PONTOS_CREDITO.CD_CLI,
	RC_CLI_FIDELI_PONTOS_CREDITO.QTDE_PONTOS,
	RC_CLI_FIDELI_PONTOS_CREDITO.DT_CAD,
	PDV_VD.CD_USU_CANCEL
FROM
    RC_CLI_FIDELI_PONTOS_CREDITO INNER JOIN RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO ON 
    RC_CLI_FIDELI_PONTOS_CREDITO.CD_CTR_PONTOS = RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_CTR_PONTOS 
	INNER JOIN PDV_VD ON
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_EMP = PDV_VD.CD_EMP AND
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL = PDV_VD.CD_FILIAL AND
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_VD = PDV_VD.CD_VD 
	LEFT OUTER  JOIN RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT ON
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_EMP = RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT.CD_EMP AND
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_FILIAL = RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT.CD_FILIAL AND
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_VD = RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT.CD_VD AND 
	RC_CLI_FIDELI_PONTOS_CREDITO_PDV_VD_IT_FIDELI_CARTAO.CD_IT = RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT.CD_IT
WHERE     
    PDV_VD.DT_VD BETWEEN @DT_PROC_INI AND @DT_PROC_FIM
    AND RC_CLI_FIDELI_PONTOS_CREDITO.QTDE_PONTOS>0
	AND PDV_VD.CD_EMP=@CD_EMP_PAR
	AND PDV_VD.CD_FILIAL= CASE WHEN @CD_FILIAL_PAR=0 THEN PDV_VD.CD_FILIAL ELSE @CD_FILIAL_PAR END 
	AND PDV_VD.ST_VD=1
	AND RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT.CD_VD IS NULL

	OPEN CCancelVendasFidel;
	FETCH NEXT FROM CCancelVendasFidel INTO @CD_EMP,
									@CD_FILIAL,
									@CD_VD,
									@CD_IT,
									@CD_CLI,
									@QTDE_PONTOS,
									@DT_CAD,
									@CD_USU

	WHILE @@FETCH_STATUS = 0
		BEGIN
		INSERT INTO RC_CLI_FIDELI_PONTOS_DEBITO
		(CD_EMP,
		CD_CLI,
		QTDE_PONTOS,
		DT_CAD,
		CD_USU,
		CD_MT_PONTO,
		APP_NAME)
		SELECT
			@CD_EMP,
			@CD_CLI,
			@QTDE_PONTOS,
			@DT_CAD,
			@CD_USU,
			16,
			'P_RC_CLI_ANALISE_PONTUACAO_FIDELIDADE'

		INSERT INTO RC_CLI_FIDELI_PONTOS_DEBITO_PDV_VD_IT
		SELECT
			SCOPE_IDENTITY(),
			@CD_EMP,
			@CD_FILIAL,
			@CD_VD,
			@CD_IT


		FETCH NEXT FROM CCancelVendasFidel INTO  @CD_EMP,
									@CD_FILIAL,
									@CD_VD,
									@CD_IT,
									@CD_CLI,
									@QTDE_PONTOS,
									@DT_CAD,
									@CD_USU
	END;    
    
--FECHANDO CURSOS    
CLOSE CCancelVendasFidel;    
    
--DESALOCANDO CURSOS DA MEMORIA    
DEALLOCATE CCancelVendasFidel;
END

